﻿var defaultCheckBoxImage;
var alternateCheckBoxImage;

$(document).ready(function () {
    $(":checkbox").each(function () {
        checkMaxAnswer($(this));
    });

    adjustCheckBoxLabelPadding();

    if (defaultCheckBoxImage) {
        $(".checkBox :checkbox").addClass("imageChoiceInput").hide();

        $(".checkBox :checkbox").each(function () {
            if ($(this).is(":checked")) {
                $(this).after("<img src='" + alternateCheckBoxImage + "' class='checkboxImage choiceImage' alt='' tabindex='0' />");
            }
            else {      
                $(this).after("<img src='" + defaultCheckBoxImage + "' class='checkboxImage choiceImage' alt='' tabindex='0' />");
            }
        });

        $(".checkBox .choice").on("click keyup",function (e) {
            if ((!$(this).hasClass("disabled")
                && !$(this).hasClass("openEnd")
                && !($(this).hasClass("maxDisabled") && $(this).find("img[src='" + alternateCheckBoxImage + "']").length == 0)
                && e.type === "click")
                || (e.type === "keyup" && e.keyCode === 32 && e.target.tagName !== "TEXTAREA")) {
                var gridCell = $(this).closest(".gridItem");

                if (gridCell == null || !gridCell.hasClass("disabled")) {
                    var checkBox = $(this).find(":checkbox");
                    var checkBoxImage = $(this).find(".checkboxImage");

                    if (checkBox.is(":checked")) {
                        checkBox.prop("checked", false);
                        checkBoxImage.attr("src", defaultCheckBoxImage);
                    }
                    else {
                        checkBox.prop("checked", true);
                        checkBoxImage.attr("src", alternateCheckBoxImage);
                    }

                    if (checkBox.is("[data-exclusive=true]")) {
                        // Uncheck all other checkbox that have the same name
                        $('.checkBox :checkbox[name=' + checkBox.attr('name') + '][value!=' + checkBox.val() + ']').each(function () {
                            $(this).prop('checked', false);
                            $(this).closest(".choice").find(".checkboxImage").attr("src", defaultCheckBoxImage);
                            toggleOpenEnd($(this));
                        });
                    }
                    else {
                        // Uncheck all other checkbox that have the same name and that are exclusive
                        $('.checkBox :checkbox[data-exclusive=true][name=' + checkBox.attr('name') + '][value!=' + checkBox.val() + ']').each(function () {
                            $(this).prop('checked', false);
                            $(this).closest(".choice").find(".checkboxImage").attr("src", defaultCheckBoxImage);
                            toggleOpenEnd($(this));
                        });
                    }

                    checkBox.trigger("change");

                    checkMaxAnswer(checkBox);

                    if (isInGrid(checkBox)) {
                        toggleGridOpenEnds(checkBox);
                    } else {
                        toggleOpenEnd(checkBox);
                    }

                    e.stopPropagation();
                }
            }
        });

        $(".checkBox .choice .openEndBelow, .checkBox .choice .openEndRight").on("click", function (e) {
            e.stopPropagation();
        });
    }
    else {
        $(".checkBox :checkbox").on("click", function (e) {
            if (isInGrid($(this))) {
                toggleGridOpenEnds($(this));
            } else {
                toggleOpenEnd($(this));
            }

            if ($(this).is("[data-exclusive=true]")) {
                $('.checkBox :checkbox[name=' + $(this).attr('name') + '][value!=' + $(this).val() + ']').each(function () {
                    var waschecked = $(this).prop('checked');

                    $(this).prop('checked', false);

                    if (waschecked)
                        $(this).trigger("change");

                    toggleOpenEnd($(this));
                });
            }
            else {
                $('.checkBox :checkbox[data-exclusive=true][name=' + $(this).attr('name') + '][value!=' + $(this).val() + ']').each(function () {

                    var waschecked = $(this).prop('checked');
                    $(this).prop('checked', false);


                    if (waschecked)
                        $(this).trigger("change");

                    toggleOpenEnd($(this));
                });
            }

            checkMaxAnswer($(this));
        });
    }
});

function checkMaxAnswer(element) {
    var choiceList = element.closest(".choiceList");
    var content = (choiceList.length > 0) ? element.closest(".choiceList") : element.closest("table.grid");
    var maxAnswers = content.attr("data-maxanswers");

    // For hybrid grid get column max answer and associated columns with group (list of td) for current row
    if (content.hasClass("hybridGrid")) {
        var colIndex = element.closest("td").index();

        var colGroupStartIndex = 0;
        var colspan = 0;
        var associatedHeader = null;

        $("tbody tr:eq(0) th", content).each(function (h) {
            if (!associatedHeader) {
                colspan = $(this).attr("colspan") ? parseInt($(this).attr("colspan"), 10) : 0;

                if (colGroupStartIndex <= colIndex && (colIndex <= colGroupStartIndex + colspan))
                    associatedHeader = $(this);
                else
                    colGroupStartIndex++;
            }
        });

        if (associatedHeader && associatedHeader.attr("data-maxanswers")) {
            maxAnswers = associatedHeader.attr("data-maxanswers");
        }
    }

    if (maxAnswers) {
        var checkboxes = $(".checkBox :checkbox[name='" + element.attr("name") + "']");
        var checked = checkboxes.filter(":checked").length;

        if (checked == parseInt(maxAnswers)) {
            checkboxes.filter(":not(:checked)").prop("disabled", true);
            checkboxes.closest("div.choice").addClass("maxDisabled");
        }
        else {
            checkboxes.filter(":not(:checked)").prop("disabled", false);
            checkboxes.closest("div.choice").removeClass("maxDisabled");
        }
    }
}

function adjustCheckBoxLabelPadding() {
    if (defaultCheckBoxImage) {
        $("body").append($("<div class='tempContainer standard'><div class='choiceList'><div class='choice'></div></div></div>"));

        $(".tempContainer .choice").append("<img src='" + alternateCheckBoxImage + "' class='checkboxImage selectedImage choiceImage' />");
        $(".tempContainer .choice").append("<img src='" + defaultCheckBoxImage + "' class='checkboxImage defaultImage choiceImage' />");

        $(".tempContainer").imagesLoaded(function () {
            var defaultImage = $(".tempContainer .defaultImage");
            var selectedImage = $(".tempContainer .selectedImage");

            var imageHeight = Math.max(defaultImage.height(), selectedImage.height());

            if (imageHeight > 0) {
                var paddingLeft = Math.max(defaultImage.outerWidth(true), selectedImage.outerWidth(true));
                $(".checkBox .choice label").css("line-height", imageHeight + "px");
                $(".checkBox .vertical .choice label").css("padding-left", paddingLeft + "px");
                $(".checkBox .openEndBelow").css("margin-left", paddingLeft + "px");

                $(".tempContainer").remove();
            }
        });
    }
    else {
        var paddingLeft = $(".checkBox :checkbox").first().outerWidth(true);
        $(".checkBox .vertical .choice label").css("padding-left", paddingLeft + "px");
        $(".checkBox .openEndBelow").css("margin-left", paddingLeft + "px");
    }
}